/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeClientPlayer;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.FakeThreadDownloadImageData;
import customskinloader.fake.IFakeImageBuffer;
import customskinloader.fake.itf.FakeInterfaceManager;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;

public class FakeSkinManager {
    private final TextureManager textureManager;
    private final Map<ResourceLocation, MinecraftProfileTexture> modelCache = new ConcurrentHashMap<ResourceLocation, MinecraftProfileTexture>();

    public FakeSkinManager(TextureManager textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        return this.loadSkin(profileTexture, textureType, null);
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, SkinManager.SkinTextureCallback skinAvailableCallback) {
        return this.loadSkin(profileTexture, HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl()), textureType, skinAvailableCallback);
    }

    private ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, HttpTextureUtil.HttpTextureInfo info, MinecraftProfileTexture.Type textureType, SkinManager.SkinTextureCallback skinAvailableCallback) {
        ResourceLocation resourcelocation = new ResourceLocation("skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)info.hash).toString());
        if (FakeInterfaceManager.TextureManager_getTexture(this.textureManager, resourcelocation, null) != null) {
            FakeSkinManager.makeCallback(skinAvailableCallback, textureType, resourcelocation, this.modelCache.getOrDefault(resourcelocation, profileTexture));
        } else {
            SimpleTexture threaddownloadimagedata = FakeThreadDownloadImageData.createThreadDownloadImageData(info.cacheFile, info.url, DefaultPlayerSkin.m_118626_(), new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, profileTexture), textureType);
            if (skinAvailableCallback instanceof FakeClientPlayer.LegacyBuffer) {
                FakeClientPlayer.textureCache.put(resourcelocation, (ITextureObject)threaddownloadimagedata);
            }
            FakeInterfaceManager.TextureManager_loadTexture(this.textureManager, resourcelocation, threaddownloadimagedata);
        }
        return resourcelocation;
    }

    public void loadProfileTextures(GameProfile profile, SkinManager.SkinTextureCallback skinAvailableCallback, boolean requireSecure) {
        CustomSkinLoader.loadProfileTextures(() -> CustomSkinLoader.loadProfileLazily(profile, m -> {
            HashMap map = Maps.newHashMap();
            map.putAll(m);
            for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)map.get(type);
                if (profileTexture == null) continue;
                HttpTextureUtil.HttpTextureInfo info = HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl());
                FakeThreadDownloadImageData.downloadTexture(info.cacheFile, info.url);
                FakeInterfaceManager.Minecraft_addScheduledTask(Minecraft.m_91087_(), () -> {
                    CustomSkinLoader.logger.debug("Loading type: " + type);
                    try {
                        this.loadSkin(profileTexture, info, type, skinAvailableCallback);
                    }
                    catch (Throwable t) {
                        CustomSkinLoader.logger.warning(t);
                    }
                });
            }
        }));
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = CustomSkinLoader.loadProfileFromCache(profile);
        Iterator<Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture> entry = it.next();
            MinecraftProfileTexture texture = entry.getValue();
            if (!FakeSkinManager.shouldJudgeType(texture)) continue;
            if ((texture = this.modelCache.get(this.loadSkin(texture, entry.getKey()))) == null) {
                it.remove();
                continue;
            }
            map.put(entry.getKey(), texture);
        }
        return map;
    }

    private static void makeCallback(SkinManager.SkinTextureCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.m_118856_(type, location, texture);
        }
    }

    private static boolean shouldJudgeType(MinecraftProfileTexture texture) {
        return texture != null && "auto".equals(texture.getMetadata("model"));
    }

    private class BaseBuffer
    implements IFakeImageBuffer {
        private IFakeImageBuffer buffer;
        private SkinManager.SkinTextureCallback callback;
        private MinecraftProfileTexture.Type type;
        private ResourceLocation location;
        private MinecraftProfileTexture texture;

        public BaseBuffer(SkinManager.SkinTextureCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer(location);
                }
            }
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        @Override
        public BufferedImage parseUserSkin(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).parseUserSkin(image) : image;
        }

        @Override
        public void skinAvailable() {
            if (this.buffer != null) {
                this.buffer.skinAvailable();
                if (FakeSkinManager.shouldJudgeType(this.texture) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    metadata.put("model", type);
                    this.texture = new MinecraftProfileTexture(this.texture.getUrl(), (Map)metadata);
                    FakeSkinManager.this.modelCache.put(this.location, this.texture);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

